/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.signture;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.NulsSignData;
import io.nuls.base.data.Transaction;
import io.nuls.base.script.Script;
import io.nuls.base.script.ScriptBuilder;
import io.nuls.base.script.ScriptChunk;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Component
public class SignatureUtil {
    private static final int MAIN_CHAIN_ID = 1;

    public static boolean validateTransactionSignture(int chainId, Transaction tx) throws NulsException {
        block14: {
            boolean forked;
            long hardForkingHeight = 878000L;
            boolean bl = forked = tx.getBlockHeight() <= 0L || tx.getBlockHeight() > hardForkingHeight;
            if (chainId != 1) {
                forked = true;
            }
            try {
                if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
                    throw new NulsException((Throwable)new Exception());
                }
                if (!tx.isMultiSignTx()) {
                    TransactionSignature transactionSignature = new TransactionSignature();
                    transactionSignature.parse(tx.getTransactionSignature(), 0);
                    if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
                        throw new NulsException((Throwable)new Exception("Transaction unsigned \uff01"));
                    }
                    if (forked) {
                        for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
                            if (ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) continue;
                            throw new NulsException((Throwable)new Exception("Transaction signature error !"));
                        }
                        break block14;
                    }
                    int signCount = tx.getCoinDataInstance().getFromAddressCount();
                    int passCount = 0;
                    for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
                        if (!ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                            throw new NulsException((Throwable)new Exception("Transaction signature error !"));
                        }
                        if (++passCount < signCount) continue;
                        break block14;
                    }
                    break block14;
                }
                MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
                    throw new NulsException((Throwable)new Exception("Transaction unsigned \uff01"));
                }
                List<P2PHKSignature> validSignatures = transactionSignature.getValidSignature();
                int validCount = 0;
                for (P2PHKSignature signature : validSignatures) {
                    if (ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                        ++validCount;
                    }
                    if (forked || validCount < transactionSignature.getM()) continue;
                    break;
                }
                if (validCount < transactionSignature.getM()) {
                    throw new NulsException((Throwable)new Exception("Transaction signature error !"));
                }
            }
            catch (NulsException e) {
                Log.error((String)"TransactionSignature parse error!");
                throw e;
            }
        }
        return true;
    }

    public static boolean ctxSignatureValid(int chainId, Transaction tx) throws NulsException {
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            throw new NulsException((Throwable)new Exception());
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        if (transactionSignature.getP2PHKSignatures() == null || transactionSignature.getP2PHKSignatures().size() == 0) {
            throw new NulsException((Throwable)new Exception("Transaction unsigned \uff01"));
        }
        Set<String> fromAddressSet = tx.getCoinDataInstance().getFromAddressList();
        int signCount = tx.getCoinDataInstance().getFromAddressCount();
        int passCount = 0;
        for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
            if (!ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) {
                throw new NulsException((Throwable)new Exception("Transaction signature error !"));
            }
            String signAddress = AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId));
            if (!fromAddressSet.contains(signAddress)) continue;
            fromAddressSet.remove(signAddress);
            if (++passCount < signCount || !fromAddressSet.isEmpty()) continue;
            break;
        }
        if (passCount < signCount || !fromAddressSet.isEmpty()) {
            throw new NulsException((Throwable)new Exception("Transaction signature error !"));
        }
        return true;
    }

    public static boolean validateCtxSignture(Transaction tx) throws NulsException {
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            return tx.getType() == 25 || tx.getType() == 24;
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        transactionSignature.parse(tx.getTransactionSignature(), 0);
        for (P2PHKSignature signature : transactionSignature.getP2PHKSignatures()) {
            if (ECKey.verify((byte[])tx.getHash().getBytes(), (byte[])signature.getSignData().getSignBytes(), (byte[])signature.getPublicKey())) continue;
            throw new NulsException((Throwable)new Exception("Transaction signature error !"));
        }
        return true;
    }

    public static boolean validateSignture(byte[] digestBytes, P2PHKSignature p2PHKSignature) throws NulsException {
        if (null == p2PHKSignature) {
            throw new NulsException((Throwable)new Exception("P2PHKSignature is null!"));
        }
        return ECKey.verify((byte[])digestBytes, (byte[])p2PHKSignature.getSignData().getSignBytes(), (byte[])p2PHKSignature.getPublicKey());
    }

    public static boolean containsAddress(Transaction tx, byte[] address, int chainId) throws NulsException {
        Set<String> addressSet = SignatureUtil.getAddressFromTX(tx, chainId);
        if (addressSet == null || addressSet.size() == 0) {
            return false;
        }
        return addressSet.contains(AddressTool.getStringAddressByBytes(address));
    }

    public static Set<String> getAddressFromTX(Transaction tx, int chainId) throws NulsException {
        HashSet<String> addressSet = new HashSet<String>();
        if (tx.getTransactionSignature() == null || tx.getTransactionSignature().length == 0) {
            return null;
        }
        try {
            List<P2PHKSignature> p2PHKSignatures;
            TransactionSignature transactionSignature;
            if (tx.isMultiSignTx()) {
                transactionSignature = new MultiSignTxSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            } else {
                transactionSignature = new TransactionSignature();
                transactionSignature.parse(tx.getTransactionSignature(), 0);
                p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            }
            if (p2PHKSignatures == null || p2PHKSignatures.size() == 0) {
                return null;
            }
            for (P2PHKSignature signature : p2PHKSignatures) {
                if (signature.getPublicKey() == null || signature.getPublicKey().length == 0) continue;
                addressSet.add(AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId)));
            }
        }
        catch (NulsException e) {
            Log.error((String)"TransactionSignature parse error!");
            throw e;
        }
        return addressSet;
    }

    public static Set<String> getAddressesAndVerifySignature(int chainId, byte[] data, byte[] signatureBytes) {
        List<P2PHKSignature> p2PHKSignatures;
        if (signatureBytes == null || signatureBytes.length == 0) {
            return null;
        }
        HashSet<String> addressSet = new HashSet<String>();
        try {
            TransactionSignature transactionSignature = new TransactionSignature();
            transactionSignature.parse(signatureBytes, 0);
            p2PHKSignatures = transactionSignature.getP2PHKSignatures();
        }
        catch (Exception e) {
            return null;
        }
        if (p2PHKSignatures == null || p2PHKSignatures.size() == 0) {
            return null;
        }
        for (P2PHKSignature signature : p2PHKSignatures) {
            try {
                if (!SignatureUtil.validateSignture(data, signature)) {
                    return null;
                }
            }
            catch (NulsException e) {
                return null;
            }
            if (signature.getPublicKey() == null || signature.getPublicKey().length == 0) continue;
            addressSet.add(AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId)));
        }
        return addressSet;
    }

    public static Set<String> getAddressesFromSignature(int chainId, byte[] signatureBytes) {
        List<P2PHKSignature> p2PHKSignatures;
        if (signatureBytes == null || signatureBytes.length == 0) {
            return null;
        }
        HashSet<String> addressSet = new HashSet<String>();
        try {
            TransactionSignature transactionSignature = new TransactionSignature();
            transactionSignature.parse(signatureBytes, 0);
            p2PHKSignatures = transactionSignature.getP2PHKSignatures();
        }
        catch (Exception e) {
            return null;
        }
        if (p2PHKSignatures == null || p2PHKSignatures.size() == 0) {
            return null;
        }
        for (P2PHKSignature signature : p2PHKSignatures) {
            if (signature.getPublicKey() == null || signature.getPublicKey().length == 0) continue;
            addressSet.add(AddressTool.getStringAddressByBytes(AddressTool.getAddress(signature.getPublicKey(), chainId)));
        }
        return addressSet;
    }

    public static void createTransactionSignture(Transaction tx, List<ECKey> signEckeys) throws IOException {
        if (signEckeys == null || signEckeys.size() == 0) {
            Log.error((String)"TransactionSignature signEckeys is null!");
            throw new NullPointerException();
        }
        TransactionSignature transactionSignature = new TransactionSignature();
        List<P2PHKSignature> p2PHKSignatures = null;
        try {
            p2PHKSignatures = SignatureUtil.createSignaturesByEckey(tx, signEckeys);
            transactionSignature.setP2PHKSignatures(p2PHKSignatures);
            tx.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            Log.error((String)"TransactionSignature serialize error!");
            throw e;
        }
    }

    public static List<P2PHKSignature> createSignaturesByEckey(Transaction tx, List<ECKey> eckeys) {
        ArrayList<P2PHKSignature> signatures = new ArrayList<P2PHKSignature>();
        for (ECKey ecKey : eckeys) {
            signatures.add(SignatureUtil.createSignatureByEckey(tx, ecKey));
        }
        return signatures;
    }

    public static List<P2PHKSignature> createSignaturesByEckey(NulsHash hash, List<ECKey> eckeys) {
        ArrayList<P2PHKSignature> signatures = new ArrayList<P2PHKSignature>();
        for (ECKey ecKey : eckeys) {
            signatures.add(SignatureUtil.createSignatureByEckey(hash, ecKey));
        }
        return signatures;
    }

    public static P2PHKSignature createSignatureByPriKey(Transaction tx, String priKey) {
        ECKey ecKey = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)priKey)));
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(tx.getHash().getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static P2PHKSignature createSignatureByEckey(Transaction tx, ECKey ecKey) {
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(tx.getHash().getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static P2PHKSignature createSignatureByEckey(NulsHash hash, ECKey ecKey) {
        P2PHKSignature p2PHKSignature = new P2PHKSignature();
        p2PHKSignature.setPublicKey(ecKey.getPubKey());
        p2PHKSignature.setSignData(SignatureUtil.signDigest(hash.getBytes(), ecKey));
        return p2PHKSignature;
    }

    public static List<Script> createInputScripts(List<byte[]> signtures, List<byte[]> pubkeys) {
        ArrayList<Script> scripts = new ArrayList<Script>();
        if (signtures == null || pubkeys == null || signtures.size() != pubkeys.size()) {
            return null;
        }
        for (int i = 0; i < signtures.size(); ++i) {
            scripts.add(SignatureUtil.createInputScript(signtures.get(i), pubkeys.get(i)));
        }
        return scripts;
    }

    public static Script createInputScript(byte[] signture, byte[] pubkey) {
        Script script = null;
        if (signture != null && pubkey != null) {
            script = ScriptBuilder.createNulsInputScript(signture, pubkey);
        }
        return script;
    }

    public static Script createOutputScript(byte[] address) {
        Script script = null;
        if (address == null || address.length < 23) {
            return null;
        }
        script = address[2] == BaseConstant.P2SH_ADDRESS_TYPE ? ScriptBuilder.createOutputScript(address, 0) : ScriptBuilder.createOutputScript(address, 1);
        return script;
    }

    public static Script createP2shScript(List<byte[]> signtures, List<byte[]> pubkeys, int m) {
        Script scriptSig = null;
        Script redeemScript = ScriptBuilder.createByteNulsRedeemScript(m, pubkeys);
        scriptSig = ScriptBuilder.createNulsP2SHMultiSigInputScript(signtures, redeemScript);
        return scriptSig;
    }

    public static boolean validScriptSign(byte[] digestBytes, List<ScriptChunk> chunks) {
        if (chunks == null || chunks.size() < 2) {
            return false;
        }
        if (chunks.get((int)0).opcode == 0) {
            byte[] redeemByte = chunks.get((int)(chunks.size() - 1)).data;
            Script redeemScript = new Script(redeemByte);
            List<ScriptChunk> redeemChunks = redeemScript.getChunks();
            LinkedList<byte[]> signtures = new LinkedList<byte[]>();
            for (int i = 1; i < chunks.size() - 1; ++i) {
                signtures.add(chunks.get((int)i).data);
            }
            LinkedList<byte[]> pubkeys = new LinkedList<byte[]>();
            int m = Script.decodeFromOpN(redeemChunks.get((int)0).opcode);
            if (signtures.size() < m) {
                return false;
            }
            for (int j = 1; j < redeemChunks.size() - 2; ++j) {
                pubkeys.add(redeemChunks.get((int)j).data);
            }
            int n = Script.decodeFromOpN(redeemChunks.get((int)(redeemChunks.size() - 2)).opcode);
            if (n != pubkeys.size() || n < m) {
                return false;
            }
            return SignatureUtil.validMultiScriptSign(digestBytes, signtures, pubkeys);
        }
        return ECKey.verify((byte[])digestBytes, (byte[])chunks.get((int)0).data, (byte[])chunks.get((int)1).data);
    }

    public static int getM(Script redeemScript) {
        return Script.decodeFromOpN(redeemScript.getChunks().get((int)0).opcode);
    }

    public static boolean validMultiScriptSign(byte[] digestBytes, LinkedList<byte[]> signtures, LinkedList<byte[]> pubkeys) {
        while (signtures.size() > 0) {
            byte[] pubKey = pubkeys.pollFirst();
            if (ECKey.verify((byte[])digestBytes, (byte[])signtures.getFirst(), (byte[])pubKey)) {
                signtures.pollFirst();
            }
            if (signtures.size() <= pubkeys.size()) continue;
            return false;
        }
        return true;
    }

    public static NulsSignData signDigest(byte[] digest, ECKey ecKey) {
        byte[] signbytes = ecKey.sign(digest);
        NulsSignData nulsSignData = new NulsSignData();
        nulsSignData.setSignBytes(signbytes);
        return nulsSignData;
    }
}

