/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.signture;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TransactionSignature
extends BaseNulsData {
    protected List<P2PHKSignature> p2PHKSignatures;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        if (this.p2PHKSignatures != null && this.p2PHKSignatures.size() > 0) {
            for (P2PHKSignature p2PHKSignature : this.p2PHKSignatures) {
                if (p2PHKSignature == null) continue;
                stream.writeNulsData(p2PHKSignature);
            }
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int course = 0;
        ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
        while (!byteBuffer.isFinished()) {
            course = byteBuffer.getCursor();
            byteBuffer.setCursor(course);
            p2PHKSignatures.add(byteBuffer.readNulsData(new P2PHKSignature()));
        }
        this.p2PHKSignatures = p2PHKSignatures;
    }

    public int size() {
        int size = 0;
        if (this.p2PHKSignatures != null && this.p2PHKSignatures.size() > 0) {
            for (P2PHKSignature p2PHKSignature : this.p2PHKSignatures) {
                if (p2PHKSignature == null) continue;
                size += SerializeUtils.sizeOfNulsData((NulsData)p2PHKSignature);
            }
        }
        return size;
    }

    public List<P2PHKSignature> getP2PHKSignatures() {
        return this.p2PHKSignatures;
    }

    public void setP2PHKSignatures(List<P2PHKSignature> p2PHKSignatures) {
        this.p2PHKSignatures = p2PHKSignatures;
    }

    public int getSignersCount() {
        return this.p2PHKSignatures == null ? 0 : this.p2PHKSignatures.size();
    }
}

